(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14875,        383]*)
(*NotebookOutlinePosition[     15624,        409]*)
(*  CellTagsIndexPosition[     15580,        405]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["Series de Fourier", "Title"],

Cell[CellGroupData[{

Cell["Inicializaci\[OAcute]n", "Section"],

Cell[BoxData[{
    \(\(Unprotect[Plot];\)\), "\[IndentingNewLine]", 
    \(Plot[f_, {x_, lims__ /; Length[{lims}] > 2}, 
        opts___] := \[IndentingNewLine]Block[{intervalos, discont, graf, 
          lineas, us}, \[IndentingNewLine]intervalos = \
\[IndentingNewLine]\(({#[\([1]\)] + \ 10. \^\(-15\), #[\([2]\)] - \ 
                    10. \^\(-15\)} &)\) /@ 
            Partition[{lims}, 2, 
              1]; \[IndentingNewLine]graf = \((Plot[f, 
                  Evaluate[
                    Prepend[#, 
                      x]], \[IndentingNewLine]DisplayFunction \[Rule] 
                    Identity, opts] &)\) /@ 
            intervalos; \[IndentingNewLine]discont = \((Drop[
                  Drop[{lims}, 1], \(-1\)] /. 
                us_?NumberQ \[Rule] {us - 10. \^\(-15\), 
                    us + 10. \^\(-15\)})\) // 
            Flatten; \[IndentingNewLine]discont = 
          discont /. 
            us_?NumberQ \[Rule] \ {us, 
                f /. x \[Rule] us}; \[IndentingNewLine]lineas = 
          Line /@ Partition[discont, 2]; \[IndentingNewLine]Show[{graf, 
            Graphics[{Dashing[{ .01,  .01}], 
                lineas}]}, \[IndentingNewLine]DisplayFunction \[Rule] \
$DisplayFunction]]\), "\[IndentingNewLine]", 
    \(\(Protect[Plot];\)\)}], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[BoxData[{
    \(\(\(sptamp[p_, q_, period_] := 
      Table[{k/period, 
          Abs[If[IntegerQ[k]\  && \ 
                k \[GreaterEqual] 0, \((a[k] - \[ImaginaryI]\ b[k])\)/
                2. , \((a[\(-k\)] + \[ImaginaryI]\ b[\(-k\)])\)/2. ]]}, {k, 
          p, q, 1}]\)\(\n\)
    \) (*\ construye\ el\ espectro\ de\ amplitudes\ para\ p \[LessEqual] 
        k \[LessEqual] q\ *) \), "\n", 
    \(\(\(SpectrumAmplitudesPlot[p_, q_, period_, opts___] := 
      Show[Graphics[{\((Line[{{#1[\([1]\)], 0}, #1}] &)\) /@ 
              sptamp[p, q, 
                period], \(({Hue[0], 
                    PointSize[If[#[\([2]\)] > 0,  .016,  .012]], 
                    Point[#]} &)\) /@ sptamp[p, q, period]}, opts]]\)\(\n\)
    \) (*\ representa\ el\ espectro\ de\ amplitudes\ para\ p \[LessEqual] 
        k \[LessEqual] q\ *) \), "\n", 
    \(\(\(sptfases[p_, q_, period_] := 
      Table[{k/period, 
          Which[N[a[k]] \[Equal] N[b[k]] \[Equal] 0, 0, 
            IntegerQ[k]\ \  && \ k \[GreaterEqual] 0, 
            Arg[\((a[k] - \[ImaginaryI]\ b[k])\)/2. ], 
            IntegerQ[k]\ \  && \ k \[LessEqual] \(-1\), 
            Arg[\((a[\(-k\)] + \[ImaginaryI]\ b[\(-k\)])\)/2. ]]}, {k, p, q, 
          1}]\)\(\n\)
    \) (*\ construye\ el\ espectro\ de\ fases\ para\ p \[LessEqual] 
        k \[LessEqual] q\ *) \), "\n", 
    \(SpectrumFasesPlot[p_, q_, period_, opts___] := 
      Show[Graphics[{\((Line[{{#1[\([1]\)], 0}, #1}] &)\) /@ 
              sptfases[p, q, 
                period], \(({Hue[0], 
                    PointSize[If[#[\([2]\)] \[NotEqual] 0,  .016,  .0]], 
                    Point[#]} &)\) /@ sptfases[p, q, period]}, 
          opts]]\), "\n", 
    \( (*\ representa\ el\ espectro\ de\ fases\ para\ p \[LessEqual] 
        k \[LessEqual] q\ *) \)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["La serie de Fourier de la funci\[OAcute]n diente de sierra", "Section"],

Cell[BoxData[
    \(\(Plot[Mod[t, 1], {t, \(-3\), \(-2\), \(-1\), 0, 1, 2, 3}, 
        AspectRatio -> Automatic, Ticks -> {Automatic, {1}}, 
        PlotRange -> {{\(-3.1\), 3.1}, {\(- .1\), 1.1}}, 
        PlotStyle \[Rule] {Thickness[ .004], Hue[0]}, 
        ImageSize \[Rule] {470, 90.625}];\)\)], "Input"],

Cell[BoxData[{
    \(\(T = 1;\)\), "\[IndentingNewLine]", 
    \({c[n_] = 
        Simplify[\(1\/T\) 
            Integrate[Mod[t, 1]*Exp[\(-2\)\ \[Pi]\ I\ n\ t/T], {t, 0, T}], 
          n \[Element] Integers], \[IndentingNewLine]c[0] = \(1\/T\) 
          Integrate[Mod[t, 1], {t, 0, T}]}\)}], "Input"],

Cell[BoxData[
    \({a[0] = 2*c[0], a[n_] = c[n] + c[\(-n\)], b[0] = 0, 
        b[n_] = I \((c[n] - c[\(-n\)])\)} // Simplify\)], "Input"],

Cell[BoxData[{
    \(S[n_, t_] := \(S[n, t] = 
        a[0]/2 + 
          Plus @@ \ Table[
              b[k] Sin[2\ \[Pi]\ k\ t], {k, 1, 
                n}]\)\), "\[IndentingNewLine]", 
    \( (*\ polinomio\ de\ Fourier\ de\ orden\ n\ de\ f\ *) \)}], "Input"],

Cell[BoxData[{
    \(Off[Graphics::"\<gptn\>"]\), "\[IndentingNewLine]", 
    \(Do[Plot[{Mod[t, 1], S[n, t]}, {t, \(-3\), \(-2\), \(-1\), 0, 1, 2, 3}, 
        PlotRange \[Rule] {{\(-3.1\), 3.1}, {\(- .2\), 1.3}}, 
        AspectRatio \[Rule] Automatic, Ticks \[Rule] {Automatic, None}, 
        PlotStyle \[Rule] {{Thickness[ .004], Hue[0]}, {Thickness[ .0035], 
              Hue[ .65]}}, ImageSize \[Rule] {439.25, 106.125}, 
        PlotLabel -> 
          StyleForm["\<Aproximaci\[OAcute]n por el polinomio de Fourier de \
orden n=\>" <> ToString[n], FontFamily \[Rule] Times, 
            FontSize \[Rule] 12]], {n, 2, 18, 2}]\)}], "Input"],

Cell[BoxData[{
    \(\(Play[Mod[100\ t, 1], {t, 0, 1}];\)\), "\[IndentingNewLine]", 
    \(\(Play[Evaluate[S[28, 100\ t]], {t, 0, 1}];\)\)}], "Input"],

Cell[BoxData[{
    \(\(SpectrumAmplitudesPlot[\(-18\), 18, 1, 
        Axes \[Rule] True];\)\), "\[IndentingNewLine]", 
    \(\(SpectrumFasesPlot[\(-18\), 18, 1, Axes \[Rule] True];\)\)}], "Input"],

Cell[BoxData[
    \(Clear["\<Global`*\>"]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Coeficientes de Fourier y polinomios de Fourier", "Section"],

Cell[BoxData[{
    \(\(A[func_, n_, {c_, d_}] := \(A[func, n, {c, d}] = 
          Integrate[
            2\/\(d - c\)\ Cos[\(2\ n\ \[Pi]\ t\)\/\(d - c\)]\ func[t], {t, c, 
              d}, Assumptions \[Rule] 
              n \[Element] \ Integers]\);\)\), "\[IndentingNewLine]", 
    \(\(B[func_, n_, {c_, d_}] := \(B[func, n, {c, d}] = 
          Integrate[
            2\/\(d - c\)\ Sin[\(2\ n\ \[Pi]\ t\)\/\(d - c\)]\ func[t], {t, c, 
              d}, Assumptions \[Rule] 
              n \[Element] \ Integers]\);\)\)}], "Input"],

Cell[BoxData[{
    \(\(f[t_] = t*Sin[t];\)\), "\[IndentingNewLine]", 
    \({A[f, n, {\(-Pi\), Pi}], B[f, n, {\(-Pi\), Pi}]}\)}], "Input"],

Cell[BoxData[
    \(\(PoliFourier[func_, n_, {c_, d_}]\)[
        t_] := \[IndentingNewLine]A[func, 0, {c, d}]/2 + 
        Plus @@ Table[
            A[func, m, {c, d}]\ Cos[\(2\ m\ \[Pi]\ t\)\/\(d - c\)] + 
              B[func, m, {c, d}]\ Sin[\(2\ m\ \[Pi]\ t\)\/\(d - c\)], {m, 1, 
              n}]\)], "Input"],

Cell[BoxData[
    \(\(Table[\(p[k]\)[t_] = \(PoliFourier[f, k, {\(-Pi\), Pi}]\)[t], {k, 2, 
          6, 2}];\)\)], "Input"],

Cell[BoxData[
    \(Simplify[\(p[6]\)[t] \[Equal] \(p[6]\)[t + 2  Pi]]\)], "Input"],

Cell["\<\
El siguiente comando proporciona la periodizaci\[OAcute]n par de la funci\
\[OAcute]n \"func\" en el intervalo [a,b]. Es decir, \"periodiza[func,a,b][x]\
\" es una funci\[OAcute]n peri\[OAcute]dica de periodo b-a y que coincide con \
\"func\" en [a,b].\
\>", "Text"],

Cell[BoxData[
    \(\(\(periodiza[func_, a_, b_]\)[x_] := 
        func[Mod[x, b - a, a]];\)\)], "Input"],

Cell[BoxData[
    StyleBox[\(Plot[{\(periodiza[f, \(-\[Pi]\), \[Pi]]\)[x], 
            f[x]}, {x, \(-5\) \[Pi], 5  \[Pi]}, 
          PlotStyle \[Rule] {{Thickness[0.007], Hue[0]}, Hue[0.65]}, 
          PlotRange \[Rule] All];\),
      FontFamily->"Courier New"]], "Input"],

Cell[BoxData[
    StyleBox[\(Plot[{\(periodiza[f, \(-\[Pi]\), \[Pi]]\)[t], \(p[6]\)[t], 
            f[t]}, {t, \(-5\) \[Pi], 5  \[Pi]}, 
          PlotStyle \[Rule] {{Thickness[0.007], Hue[0]}, Hue[0.65], 
              Hue[ .45]}, PlotRange \[Rule] All];\),
      FontFamily->"Courier New"]], "Input"],

Cell[BoxData[
    StyleBox[\(Plot[{\(periodiza[f, 0, 4  \[Pi]]\)[x], 
            f[x]}, {x, \(-8\) \[Pi], 8  \[Pi]}, 
          PlotStyle \[Rule] {{Thickness[0.006], Hue[0]}, Hue[0.65]}, 
          PlotRange \[Rule] All];\),
      FontFamily->"Courier New"]], "Input"],

Cell[BoxData[{
    \(\(Remove[A, B];\)\), "\[IndentingNewLine]", 
    \(\(A[func_, n_, {c_, d_}] := \(A[func, n, {c, d}] = 
          Integrate[
            2\/\(d - c\)\ Cos[\(2\ n\ \[Pi]\ t\)\/\(d - c\)]\ func[t], {t, c, 
              d}, Assumptions \[Rule] n \[Element] \ Integers]\);\)\), "\n", 
    \(\(B[func_, n_, {c_, d_}] := \(B[func, n, {c, d}] = 
          Integrate[
            2\/\(d - c\)\ Sin[\(2\ n\ \[Pi]\ t\)\/\(d - c\)]\ func[t], {t, c, 
              d}, Assumptions \[Rule] 
              n \[Element] \ Integers]\);\)\), "\[IndentingNewLine]", 
    \(\(PoliFourier[func_, n_, {c_, d_}]\)[
        t_] := \[IndentingNewLine]A[func, 0, {c, d}]/2 + 
        Plus @@ Table[
            A[func, m, {c, d}]\ Cos[\(2\ m\ \[Pi]\ t\)\/\(d - c\)] + 
              B[func, m, {c, d}]\ Sin[\(2\ m\ \[Pi]\ t\)\/\(d - c\)], {m, 1, 
              n}]\)}], "Input"],

Cell[BoxData[
    \(\(Table[\(pol[k]\)[t_] = \(PoliFourier[f, k, {0, 4  Pi}]\)[t], {k, 2, 
          10, 2}];\)\)], "Input"],

Cell[BoxData[
    StyleBox[\(Plot[{\(periodiza[f, 0, 4  \[Pi]]\)[t], \(pol[4]\)[
              t]}, {t, \(-8\) \[Pi], 8  \[Pi]}, 
          PlotStyle \[Rule] {{Thickness[ .006], Hue[0]}, Hue[0.65]}, 
          PlotRange \[Rule] All];\),
      FontFamily->"Courier New"]], "Input"],

Cell["\<\
El siguiente comando proporciona la periodizaci\[OAcute]n par de la funci\
\[OAcute]n \"func\" en el intervalo [-L,L]. Es decir, \
\"periodizapar[func,L][x]\" es una funci\[OAcute]n par peri\[OAcute]dica de \
periodo 2L y que coincide con \"func\" en [0,L].\
\>", "Text"],

Cell[BoxData[
    \(\(\(periodizapar[func_, L_]\)[x_] := 
        func[Abs[Mod[x, \(-2\) L, L]]];\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[{\(periodizapar[Exp, 1]\)[x], Exp[x]}, {x, \(-4\), 4}, 
        AspectRatio \[Rule] 1, 
        PlotRange \[Rule] {{\(-4\), 4}, {\(- .1\), 4}}, 
        AxesOrigin \[Rule] {0, 0}, 
        PlotStyle \[Rule] {{Thickness[ .007], Hue[0]}, 
            Hue[ .65]}];\)\)], "Input"],

Cell[BoxData[
    \(\(PoliCosenos[f_, n_, L_]\)[t_] := 
      Block[{a}, 
        a[k_] := \(a[k] = 
            Integrate[
              2\/L\ Cos[\(\(\ \)\(k\ \[Pi]\ t\)\)\/L]\ f[t], {t, 0, L}, 
              Assumptions \[Rule] k \[Element] \ Integers]\); 
        a[0]/2 + 
          Plus @@ Table[a[m]\ Cos[\(m\ \[Pi]\ t\)\/L], {m, 1, n}]]\)], "Input"],

Cell[BoxData[
    \(\(Table[\(p[k]\)[t_] = \(PoliCosenos[Exp, k, 1]\)[t], {k, 2, 6, 
          2}];\)\)], "Input"],

Cell[BoxData[
    StyleBox[\(Plot[{\(periodizapar[Exp, 1]\)[t], \(p[4]\)[t], 
            Exp[t]}, {t, \(-3\), 3}, 
          PlotStyle \[Rule] {{Thickness[0.007], Hue[0]}, Hue[0.65]}];\),
      FontFamily->"Courier New"]], "Input"],

Cell[BoxData[
    \(\(Table[\(p[k]\)[t_] = \(PoliCosenos[Sin, k, Pi]\)[t], {k, 2, 6, 
          2}];\)\)], "Input"],

Cell[BoxData[
    \(\(p[4]\)[t]\)], "Input"],

Cell[BoxData[
    StyleBox[\(Plot[{\(periodizapar[Sin, Pi]\)[t], \(p[4]\)[t], 
            Sin[t]}, {t, \(-3\) Pi, 3  Pi}, 
          PlotStyle \[Rule] {{Thickness[0.007], Hue[0]}, Hue[0.65], 
              Hue[ .3]}];\),
      FontFamily->"Courier New"]], "Input"],

Cell["\<\
El siguiente comando proporciona la periodizaci\[OAcute]n impar de la funci\
\[OAcute]n \"func\" en el intervalo [-L,L]. Es decir, \
\"periodizapar[func,L][x]\" es una funci\[OAcute]n impar peri\[OAcute]dica de \
periodo 2L y que coincide con \"func\" en [0,L].\
\>", "Text"],

Cell[BoxData[
    \(\(\(periodizaimpar[func_, L_]\)[x_] := 
        func[Abs[Mod[x, \(-2\) L, L]]]*
          Sign[Mod[x, \(-2\) L, L]];\)\)], "Input"],

Cell[BoxData[
    \(\(Plot[{\(periodizaimpar[Exp, 1]\)[x], Exp[x]}, {x, \(-4\), 4}, 
        AspectRatio \[Rule] 1, PlotRange \[Rule] {\(-4\), 4}, 
        AxesOrigin \[Rule] {0, 0}, 
        PlotStyle \[Rule] {{Thickness[ .007], Hue[0]}, 
            Hue[ .65]}];\)\)], "Input"],

Cell[BoxData[
    \(\(PoliSenos[f_, n_, L_]\)[t_] := 
      Block[{b}, 
        b[k_] := \(b[k] = 
            Integrate[
              2\/L\ Sin[\(\(\ \)\(k\ \[Pi]\ t\)\)\/L]\ f[t], {t, 0, L}, 
              Assumptions \[Rule] k \[Element] \ Integers]\); 
        Plus @@ Table[b[m]\ Sin[\(m\ \[Pi]\ t\)\/L], {m, 1, n}]]\)], "Input"],

Cell[BoxData[
    \(\(Table[\(p[k]\)[t_] = \(PoliSenos[Exp, k, 1]\)[t], {k, 2, 20, 
          2}];\)\)], "Input"],

Cell[BoxData[
    StyleBox[\(Plot[{\(periodizaimpar[Exp, 1]\)[t], \(p[20]\)[t], 
            Exp[t]}, {t, \(-3\), 3}, 
          PlotStyle \[Rule] {{Thickness[0.007], Hue[0]}, Hue[0.65]}];\),
      FontFamily->"Courier New"]], "Input"],

Cell[BoxData[
    RowBox[{
      RowBox[{"Do", "[", 
        StyleBox[\(Plot[{\(periodizaimpar[Exp, 1]\)[t], \(p[k]\)[t], 
              Exp[t]}, {t, \(-3\), 3}, 
            PlotStyle \[Rule] {{Thickness[0.007], Hue[0]}, Hue[0.65]}, 
            PlotRange -> {\(-3\), 9}], {k, 2, 20, 2}\),
          FontFamily->"Courier New"], 
        StyleBox["]",
          FontFamily->"Courier New"]}], 
      StyleBox[";",
        FontFamily->"Courier New"]}]], "Input"]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
AutoGeneratedPackage->None,
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 34, 0, 99, "Title"],

Cell[CellGroupData[{
Cell[1813, 55, 41, 0, 93, "Section"],
Cell[1857, 57, 1382, 28, 384, "Input",
  InitializationCell->True],
Cell[3242, 87, 1840, 36, 592, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[5119, 128, 77, 0, 61, "Section"],
Cell[5199, 130, 311, 5, 124, "Input"],
Cell[5513, 137, 304, 6, 207, "Input"],
Cell[5820, 145, 139, 2, 120, "Input"],
Cell[5962, 149, 262, 6, 120, "Input"],
Cell[6227, 157, 646, 10, 302, "Input"],
Cell[6876, 169, 150, 2, 98, "Input"],
Cell[7029, 173, 197, 3, 120, "Input"],
Cell[7229, 178, 54, 1, 94, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7320, 184, 66, 0, 93, "Section"],
Cell[7389, 186, 537, 10, 287, "Input"],
Cell[7929, 198, 138, 2, 120, "Input"],
Cell[8070, 202, 317, 6, 181, "Input"],
Cell[8390, 210, 124, 2, 94, "Input"],
Cell[8517, 214, 83, 1, 94, "Input"],
Cell[8603, 217, 276, 5, 67, "Text"],
Cell[8882, 224, 105, 2, 94, "Input"],
Cell[8990, 228, 275, 5, 120, "Input"],
Cell[9268, 235, 303, 5, 146, "Input"],
Cell[9574, 242, 269, 5, 120, "Input"],
Cell[9846, 249, 874, 16, 449, "Input"],
Cell[10723, 267, 124, 2, 94, "Input"],
Cell[10850, 271, 280, 5, 120, "Input"],
Cell[11133, 278, 281, 5, 67, "Text"],
Cell[11417, 285, 112, 2, 94, "Input"],
Cell[11532, 289, 303, 6, 146, "Input"],
Cell[11838, 297, 357, 8, 257, "Input"],
Cell[12198, 307, 114, 2, 72, "Input"],
Cell[12315, 311, 232, 4, 120, "Input"],
Cell[12550, 317, 115, 2, 94, "Input"],
Cell[12668, 321, 44, 1, 94, "Input"],
Cell[12715, 324, 265, 5, 120, "Input"],
Cell[12983, 331, 285, 5, 67, "Text"],
Cell[13271, 338, 151, 3, 120, "Input"],
Cell[13425, 343, 279, 5, 146, "Input"],
Cell[13707, 350, 335, 7, 228, "Input"],
Cell[14045, 359, 113, 2, 94, "Input"],
Cell[14161, 363, 235, 4, 120, "Input"],
Cell[14399, 369, 460, 11, 146, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

